/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.export.VWExportWizardDialog;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VWExportGeneralPanel
extends JPanel
implements IVWWizardPanel,
ActionListener {
    private JCheckBox m_includeSysConfigCheckBox = null;
    private JCheckBox m_includeUserInfoCheckBox = null;
    private JRadioButton m_exportAllRadioButton = null;
    private JRadioButton m_exportSelectedRadioButton = null;
    private ButtonGroup m_exportOptionButtonGroup = new ButtonGroup();
    private JLabel m_filePathLabel = null;
    private JTextField m_filePathTextField = null;
    private JButton m_browseButton = null;
    private Frame m_parentFrame = null;
    private VWExportWizardDialog m_parentDialog = null;
    private boolean m_showState = true;
    private JPanel m_exportTypePanel = null;
    private JPanel m_mainPanel = null;

    public VWExportGeneralPanel(VWExportWizardDialog parentDialog, Frame parentFrame) {
        this.m_parentDialog = parentDialog;
        this.m_parentFrame = parentFrame;
        this.createControls();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_browseButton) {
            FileDialog exportFileDialog = new FileDialog(this.m_parentDialog);
            exportFileDialog.setMode(1);
            exportFileDialog.setTitle(VWResource.Export);
            exportFileDialog.setFile(VWResource.ExportFileSaveFilterName);
            exportFileDialog.show();
            String filePath = exportFileDialog.getDirectory();
            String fileName = exportFileDialog.getFile();
            if (filePath != null && fileName != null) {
                this.m_filePathTextField.setText(filePath + fileName);
            }
            this.m_browseButton.requestFocus();
        } else if (object == this.m_exportAllRadioButton || object == this.m_exportSelectedRadioButton) {
            this.m_parentDialog.selectExportOption(2);
        }
    }

    public void checkForErrors() throws Exception {
        String filePath = this.m_filePathTextField.getText();
        if (filePath == null || filePath.length() <= 0) {
            throw new VWException("vw.toolkit.admin.export", "Invalid file path");
        }
        try {
            FileOutputStream ostream = new FileOutputStream(filePath);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            VWDebug.logException(ex);
        }
        this.m_parentDialog.IncludeSysConfig(this.m_includeSysConfigCheckBox.isSelected());
        this.m_parentDialog.IncludeUserInfo(this.m_includeUserInfoCheckBox.isSelected());
        this.m_parentDialog.setNextPanelDisplayState(this.m_exportSelectedRadioButton.isSelected());
        if (this.m_exportAllRadioButton.isSelected()) {
            this.m_parentDialog.exportSummary();
        }
    }

    public String getTitle() {
        return VWResource.ExportConfigTitle;
    }

    public String getInstructions() {
        return VWResource.ExportConfigInstruction;
    }

    public String getUniqueIdentifier() {
        return "EXPORT_FILE_SELECTION";
    }

    public String getHelpTopic() {
        return "general";
    }

    public void initialize() throws Exception {
    }

    public void setDisplayState(boolean bState) {
        this.m_showState = bState;
    }

    public boolean getDisplayState() {
        return this.m_showState;
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    public String getFilePath() {
        if (this.m_filePathTextField != null) {
            return this.m_filePathTextField.getText();
        }
        return null;
    }

    public boolean includeSysConfig() {
        return this.m_includeSysConfigCheckBox.isSelected();
    }

    public boolean includeUserInfo() {
        return this.m_includeUserInfoCheckBox.isSelected();
    }

    public boolean selectiveExport() {
        return this.m_exportSelectedRadioButton.isSelected();
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        if (this.m_filePathTextField != null) {
            this.m_filePathTextField.removeAll();
            this.m_filePathTextField = null;
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.removeActionListener(this);
            this.m_browseButton.removeAll();
            this.m_browseButton = null;
        }
        if (this.m_includeSysConfigCheckBox != null) {
            this.m_includeSysConfigCheckBox.removeAll();
            this.m_includeSysConfigCheckBox = null;
        }
        if (this.m_includeUserInfoCheckBox != null) {
            this.m_includeUserInfoCheckBox.removeAll();
            this.m_includeUserInfoCheckBox = null;
        }
        if (this.m_exportOptionButtonGroup != null) {
            this.m_exportOptionButtonGroup.remove(this.m_exportAllRadioButton);
            this.m_exportOptionButtonGroup.remove(this.m_exportSelectedRadioButton);
            this.m_exportOptionButtonGroup = null;
        }
        this.m_exportAllRadioButton = null;
        this.m_exportSelectedRadioButton = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.m_browseButton = new JButton(VWResource.s_browse);
            this.m_browseButton.addActionListener(this);
            this.m_filePathTextField = new JTextField();
            this.m_filePathLabel = new JLabel(VWResource.s_label.toString(VWResource.ExportFile));
            this.m_includeSysConfigCheckBox = new JCheckBox(VWResource.IncludeSystemProperties);
            this.m_includeSysConfigCheckBox.setSelected(false);
            this.m_includeUserInfoCheckBox = new JCheckBox(VWResource.IncludeUserInfos);
            this.m_includeUserInfoCheckBox.setSelected(false);
            this.m_exportAllRadioButton = new JRadioButton(VWResource.ExportAllComponents);
            this.m_exportAllRadioButton.setSelected(true);
            this.m_exportAllRadioButton.addActionListener(this);
            this.m_exportSelectedRadioButton = new JRadioButton(VWResource.ExportSelectedComponents);
            this.m_exportSelectedRadioButton.addActionListener(this);
            this.setLayout(new BorderLayout(6, 6));
            this.add((Component)this.createMainPanel(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createExportTypePanel() {
        this.m_exportTypePanel = null;
        try {
            this.m_exportTypePanel = new JPanel();
            this.m_exportTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.ExportType));
            GridBagConstraints gbConst = new GridBagConstraints();
            this.m_exportTypePanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(0, 10, 0, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_exportTypePanel.add((Component)this.m_exportAllRadioButton, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_exportTypePanel.add((Component)this.m_exportSelectedRadioButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_exportAllRadioButton, this.m_exportTypePanel, VWResource.ExportAllComponents, VWResource.ExportAllComponents);
            VWAccessibilityHelper.setAccessibility(this.m_exportSelectedRadioButton, this.m_exportTypePanel, VWResource.ExportSelectedComponents, VWResource.ExportSelectedComponents);
            VWAccessibilityHelper.setMemberOf(this.m_exportAllRadioButton, this.m_exportOptionButtonGroup);
            VWAccessibilityHelper.setMemberOf(this.m_exportSelectedRadioButton, this.m_exportOptionButtonGroup);
            this.m_exportAllRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_exportSelectedRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_exportTypePanel;
    }

    private JPanel createMainPanel() {
        this.m_mainPanel = null;
        try {
            this.m_mainPanel = new JPanel();
            GridBagConstraints gbConst = new GridBagConstraints();
            this.m_mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(5, 10, 5, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            this.m_mainPanel.add((Component)this.m_filePathLabel, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            this.m_mainPanel.add((Component)this.m_filePathTextField, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            this.m_mainPanel.add((Component)this.m_browseButton, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_mainPanel.add((Component)this.m_includeSysConfigCheckBox, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_mainPanel.add((Component)this.m_includeUserInfoCheckBox, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_mainPanel.add((Component)this.createExportTypePanel(), gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weighty = 1.0;
            gbConst.weightx = 1.0;
            this.m_mainPanel.add((Component)new JLabel(), gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_exportTypePanel, this.m_mainPanel, VWResource.ExportType, VWResource.ExportType);
            VWAccessibilityHelper.setAccessibility(this.m_filePathLabel, this.m_mainPanel, VWResource.s_label.toString(VWResource.ExportFile), VWResource.s_label.toString(VWResource.ExportFile));
            VWAccessibilityHelper.setAccessibility(this.m_filePathTextField, this.m_mainPanel, VWResource.SpecifyExportFilePath, VWResource.SpecifyExportFilePath);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, this.m_mainPanel, VWResource.Browse, VWResource.Browse);
            VWAccessibilityHelper.setAccessibility(this.m_includeSysConfigCheckBox, this.m_mainPanel, VWResource.IncludeSystemProperties, VWResource.IncludeSystemProperties);
            VWAccessibilityHelper.setAccessibility(this.m_includeUserInfoCheckBox, this.m_mainPanel, VWResource.IncludeUserInfos, VWResource.IncludeUserInfos);
            VWAccessibilityHelper.setLabelFor(this.m_filePathLabel, this.m_filePathTextField);
            this.m_filePathLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_filePathTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_browseButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_includeSysConfigCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_includeUserInfoCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_mainPanel;
    }
}

